<?php
if (!defined('_GNUBOARD_')) exit; // 개별 페이지 접근 불가 

// add_stylesheet('css 구문', 출력순서); 숫자가 작을 수록 먼저 출력됨
add_stylesheet('<link rel="stylesheet" href="'.$skin_url.'/style.css" media="screen">', 0);

?>

<div class="row">
	<div class="col-md-6 col-md-offset-3 col-sm-6 col-sm-offset-3">
		<div class="form-box">
			<div class="form-header">
				<h2><b><i class="fa fa-file-text-o"></i> Partner Stipulation</b></h2>
			</div>
			<div class="form-body">
				<form class="form" role="form" name="fregister" id="fregister" action="<?php echo $action_url ?>" onsubmit="return fregister_submit(this);" method="POST" enctype="multipart/form-data" autocomplete="off">
					<div class="form-group">
						<textarea class="form-control input-sm" rows="8" readonly><?php echo $partner_stipulation; ?></textarea>
					</div>

					<div class="form-group">
						<select name="pt_type" required class="form-control input-sm">
							<option value="">파트너 유형을 선택해 주세요.</option>
							<?php if($is_company) { ?>
								<option value="1">기업 파트너</option>
							<?php } ?>
							<?php if($is_personal) { ?>
								<option value="2">개인 파트너</option>
							<?php } ?>
						</select>
					</div>

					<div class="form-group has-feedback">
						<label for="pt_name"><b>담당자 이름</b><strong class="sound_only"> 필수</strong></label>
						<input type="text" name="pt_name" id="pt_name" class="form-control input-sm" required placeholder="실명입력">
						<span class="fa fa-user form-control-feedback"></span>
					</div>

					<div class="form-group has-feedback">
				        <label for="pt_hp"><b>담당자 연락처</b><strong class="sound_only"> 필수</strong></label>
						<input type="text" name="pt_hp" id="pt_hp" class="form-control input-sm" required placeholder="대표전화 또는 핸드폰 번호입력">
						<span class="fa fa-phone form-control-feedback"></span>
					</div>

					<div class="form-group has-feedback">
				        <label for="pt_email"><b>담당자 이메일</b><strong class="sound_only"> 필수</strong></label>
						<input type="text" name="pt_email" id="pt_email" class="form-control input-sm" required placeholder="이메일 주소입력">
						<span class="fa fa-envelope form-control-feedback"></span>
					</div>

					<div class="well well-sm">
						사업자등록증(기업) 또는 신분증(개인) 사본과 입금 통장사본을 스캔하여 반드시 첨부해 주셔야 출금신청을 할 수 있습니다.
					</div>


					<div class="form-group">
						<label><b>서류사본</b><strong class="sound_only">필수</strong></label>
						<input type="file" name="pf_file[]" class="form-control input-sm" required title="사업자등록증 또는 신분증 사본 : 용량 <?php echo $upload_max_filesize; ?> 이하만 업로드 가능">
					</div>

					<div class="form-group">
						<label><b>통장사본</b><strong class="sound_only">필수</strong></label>
						<input type="file" name="pf_file[]" class="form-control input-sm" required title="입금 통장사본 : 용량 <?php echo $upload_max_filesize; ?> 이하만 업로드 가능">
					</div>			

					<div class="form-group">
			            <label>
							<input type="checkbox" name="agree" value="1" id="agree11"> 파트너가입약관과 상기 정보제공에 동의합니다.
						</label>
					</div>

					<button type="submit" class="btn btn-color btn-block btn-lg">Sign In</button>

				</form>
			</div>
			<div class="form-footer">
				<p class="text-center">
					<a href="<?php echo G5_URL ?>"><i class="fa fa-home"></i> 홈으로</a>
				</p>
			</div>
		</div>
	</div>
</div>

<script>
    function fregister_submit(f) {
        if (!f.agree.checked) {
            alert("파트너가입약관과 정보제공에 동의하셔야 가입하실 수 있습니다.");
            f.agree.focus();
            return false;
        }

		<?php if($use_company && $use_personal) { ?>
			var type = false;
			for(var i=0;i<f.pt_type.length;i++) {
				if(f.pt_type[i].checked == true) {
					type = true;
					break;
				}
			}
			if (!type) {
	            alert("등록할 파트너 유형을 선택해 주세요.");
				return false;
		    }
		<?php } ?>

		if (confirm("파트너 등록을 신청하시겠습니까?")) {
			f.action = "<?php echo $action_url;?>";
			return true;
		}

		return false;
    }
</script>
